/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.google.common.collect.ImmutableMap;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import io.github.fabricators_of_create.porting_lib.tags.Tags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2037;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3981;
import net.minecraft.class_5794;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class RegistrateRecipeProvider
extends FabricRecipeProvider
implements RegistrateProvider,
Consumer<class_2444> {
    private final AbstractRegistrate<?> owner;
    @Nullable
    private Consumer<class_2444> callback;
    public static final int DEFAULT_SMELT_TIME = 200;
    public static final int DEFAULT_BLAST_TIME = 100;
    public static final int DEFAULT_SMOKE_TIME = 100;
    public static final int DEFAULT_CAMPFIRE_TIME = 600;
    private static final String SMELTING_NAME = "smelting";
    private static final ImmutableMap<class_1865<? extends class_1874>, String> COOKING_TYPE_NAMES = ImmutableMap.builder().put((Object)class_1865.field_9042, (Object)"smelting").put((Object)class_1865.field_17084, (Object)"blasting").put((Object)class_1865.field_17085, (Object)"smoking").put((Object)class_1865.field_17347, (Object)"campfire").build();

    public RegistrateRecipeProvider(AbstractRegistrate<?> owner, FabricDataOutput output) {
        super(output);
        this.owner = owner;
    }

    @Override
    public EnvType getSide() {
        return EnvType.SERVER;
    }

    @Override
    public void accept(@Nullable class_2444 t) {
        if (this.callback == null) {
            throw new IllegalStateException("Cannot accept recipes outside of a call to registerRecipes");
        }
        this.callback.accept(t);
    }

    public void method_10419(Consumer<class_2444> consumer) {
        this.callback = consumer;
        this.owner.genData(ProviderType.RECIPE, this);
        this.callback = null;
    }

    public class_2960 safeId(class_2960 id) {
        return new class_2960(this.owner.getModid(), this.safeName(id));
    }

    public class_2960 safeId(DataIngredient source) {
        return this.safeId(source.getId());
    }

    public class_2960 safeId(class_1935 registryEntry) {
        return this.safeId(class_7923.field_41178.method_10221((Object)registryEntry.method_8389()));
    }

    public String safeName(class_2960 id) {
        return id.method_12832().replace('/', '_');
    }

    public String safeName(DataIngredient source) {
        return this.safeName(source.getId());
    }

    public <T extends class_1935> void cooking(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience, int cookingTime, class_1865<? extends class_1874> serializer) {
        this.cooking(source, category, result, experience, cookingTime, (String)COOKING_TYPE_NAMES.get(serializer), serializer);
    }

    public <T extends class_1935> void cooking(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience, int cookingTime, String typeName, class_1865<? extends class_1874> serializer) {
        class_2454.method_17801((class_1856)source, (class_7800)category, (class_1935)((class_1935)result.get()), (float)experience, (int)cookingTime, serializer).method_10469("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_36443((Consumer)this, this.safeId((class_1935)result.get()) + "_from_" + this.safeName(source) + "_" + typeName);
    }

    public <T extends class_1935> void smelting(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience) {
        this.smelting(source, category, result, experience, 200);
    }

    public <T extends class_1935> void smelting(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, category, result, experience, cookingTime, (class_1865<? extends class_1874>)class_1865.field_9042);
    }

    public <T extends class_1935> void blasting(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience) {
        this.blasting(source, category, result, experience, 100);
    }

    public <T extends class_1935> void blasting(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, category, result, experience, cookingTime, (class_1865<? extends class_1874>)class_1865.field_17084);
    }

    public <T extends class_1935> void smoking(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience) {
        this.smoking(source, category, result, experience, 100);
    }

    public <T extends class_1935> void smoking(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, category, result, experience, cookingTime, (class_1865<? extends class_1874>)class_1865.field_17085);
    }

    public <T extends class_1935> void campfire(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience) {
        this.campfire(source, category, result, experience, 600);
    }

    public <T extends class_1935> void campfire(DataIngredient source, class_7800 category, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, category, result, experience, cookingTime, (class_1865<? extends class_1874>)class_1865.field_17347);
    }

    public <T extends class_1935> void stonecutting(DataIngredient source, class_7800 category, Supplier<? extends T> result) {
        this.stonecutting(source, category, result, 1);
    }

    public <T extends class_1935> void stonecutting(DataIngredient source, class_7800 category, Supplier<? extends T> result, int resultAmount) {
        class_3981.method_17969((class_1856)source, (class_7800)category, (class_1935)((class_1935)result.get()), (int)resultAmount).method_17970("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_36443((Consumer)this, this.safeId((class_1935)result.get()) + "_from_" + this.safeName(source) + "_stonecutting");
    }

    public <T extends class_1935> void smeltingAndBlasting(DataIngredient source, class_7800 category, Supplier<? extends T> result, float xp) {
        this.smelting(source, category, result, xp);
        this.blasting(source, category, result, xp);
    }

    public <T extends class_1935> void food(DataIngredient source, class_7800 category, Supplier<? extends T> result, float xp) {
        this.smelting(source, category, result, xp);
        this.smoking(source, category, result, xp);
        this.campfire(source, category, result, xp);
    }

    public <T extends class_1935> void square(DataIngredient source, class_7800 category, Supplier<? extends T> output, boolean small) {
        class_2447 builder = class_2447.method_10437((class_7800)category, (class_1935)((class_1935)output.get())).method_10428(Character.valueOf('X'), (class_1856)source);
        if (small) {
            builder.method_10439("XX").method_10439("XX");
        } else {
            builder.method_10439("XXX").method_10439("XXX").method_10439("XXX");
        }
        builder.method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)output.get()));
    }

    @Deprecated
    public <T extends class_1935> void storage(DataIngredient source, class_7800 category, NonNullSupplier<? extends T> output) {
        this.square(source, category, output, false);
        this.singleItemUnfinished(source, category, output, 1, 9).method_36443((Consumer)this, this.safeId(source) + "_from_" + this.safeName(class_7923.field_41178.method_10221((Object)((class_1935)output.get()).method_8389())));
    }

    public <T extends class_1935> void storage(NonNullSupplier<? extends T> source, class_7800 category, NonNullSupplier<? extends T> output) {
        this.storage(DataIngredient.items(source, new NonNullSupplier[0]), category, source, DataIngredient.items(output, new NonNullSupplier[0]), output);
    }

    public <T extends class_1935> void storage(DataIngredient sourceIngredient, class_7800 category, NonNullSupplier<? extends T> source, DataIngredient outputIngredient, NonNullSupplier<? extends T> output) {
        this.square(sourceIngredient, category, output, false);
        this.singleItemUnfinished(outputIngredient, category, source, 1, 9).method_36443((Consumer)this, this.safeId(sourceIngredient) + "_from_" + this.safeName(class_7923.field_41178.method_10221((Object)((class_1935)output.get()).method_8389())));
    }

    public <T extends class_1935> class_2450 singleItemUnfinished(DataIngredient source, class_7800 category, Supplier<? extends T> result, int required, int amount) {
        return class_2450.method_10448((class_7800)category, (class_1935)((class_1935)result.get()), (int)amount).method_10453((class_1856)source, required).method_10442("has_" + this.safeName(source), (class_184)source.getCritereon(this));
    }

    public <T extends class_1935> void singleItem(DataIngredient source, class_7800 category, Supplier<? extends T> result, int required, int amount) {
        this.singleItemUnfinished(source, category, result, required, amount).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void planks(DataIngredient source, class_7800 category, Supplier<? extends T> result) {
        this.singleItemUnfinished(source, category, result, 1, 4).method_10452("planks").method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void stairs(DataIngredient source, class_7800 category, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        class_2447.method_10436((class_7800)category, (class_1935)((class_1935)result.get()), (int)4).method_10439("X  ").method_10439("XX ").method_10439("XXX").method_10428(Character.valueOf('X'), (class_1856)source).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
        if (stone) {
            this.stonecutting(source, category, result);
        }
    }

    public <T extends class_1935> void slab(DataIngredient source, class_7800 category, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        class_2447.method_10436((class_7800)category, (class_1935)((class_1935)result.get()), (int)6).method_10439("XXX").method_10428(Character.valueOf('X'), (class_1856)source).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
        if (stone) {
            this.stonecutting(source, category, result, 2);
        }
    }

    public <T extends class_1935> void fence(DataIngredient source, class_7800 category, Supplier<? extends T> result, @Nullable String group) {
        class_2447.method_10436((class_7800)category, (class_1935)((class_1935)result.get()), (int)3).method_10439("W#W").method_10439("W#W").method_10428(Character.valueOf('W'), (class_1856)source).method_10433(Character.valueOf('#'), Tags.Items.RODS_WOODEN).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void fenceGate(DataIngredient source, class_7800 category, Supplier<? extends T> result, @Nullable String group) {
        class_2447.method_10437((class_7800)category, (class_1935)((class_1935)result.get())).method_10439("#W#").method_10439("#W#").method_10428(Character.valueOf('W'), (class_1856)source).method_10433(Character.valueOf('#'), Tags.Items.RODS_WOODEN).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void wall(DataIngredient source, class_7800 category, Supplier<? extends T> result) {
        class_2447.method_10436((class_7800)category, (class_1935)((class_1935)result.get()), (int)6).method_10439("XXX").method_10439("XXX").method_10428(Character.valueOf('X'), (class_1856)source).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
        this.stonecutting(source, category, result);
    }

    public <T extends class_1935> void door(DataIngredient source, class_7800 category, Supplier<? extends T> result, @Nullable String group) {
        class_2447.method_10436((class_7800)category, (class_1935)((class_1935)result.get()), (int)3).method_10439("XX").method_10439("XX").method_10439("XX").method_10428(Character.valueOf('X'), (class_1856)source).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public <T extends class_1935> void trapDoor(DataIngredient source, class_7800 category, Supplier<? extends T> result, @Nullable String group) {
        class_2447.method_10436((class_7800)category, (class_1935)((class_1935)result.get()), (int)2).method_10439("XXX").method_10439("XXX").method_10428(Character.valueOf('X'), (class_1856)source).method_10435(group).method_10429("has_" + this.safeName(source), (class_184)source.getCritereon(this)).method_17972((Consumer)this, this.safeId((class_1935)result.get()));
    }

    public CompletableFuture<?> method_46206(class_7403 p_253674_, class_2960 p_254102_, class_161.class_162 p_253712_) {
        return super.method_46206(p_253674_, p_254102_, p_253712_);
    }

    public static void oreSmelting(Consumer<class_2444> p_250654_, List<class_1935> p_250172_, class_7800 p_250588_, class_1935 p_251868_, float p_250789_, int p_252144_, String p_251687_) {
        class_2446.method_36233(p_250654_, p_250172_, (class_7800)p_250588_, (class_1935)p_251868_, (float)p_250789_, (int)p_252144_, (String)p_251687_);
    }

    public static void oreBlasting(Consumer<class_2444> p_248775_, List<class_1935> p_251504_, class_7800 p_248846_, class_1935 p_249735_, float p_248783_, int p_250303_, String p_251984_) {
        class_2446.method_36234(p_248775_, p_251504_, (class_7800)p_248846_, (class_1935)p_249735_, (float)p_248783_, (int)p_250303_, (String)p_251984_);
    }

    public static void oreCooking(Consumer<class_2444> p_250791_, class_1865<? extends class_1874> p_251817_, List<class_1935> p_249619_, class_7800 p_251154_, class_1935 p_250066_, float p_251871_, int p_251316_, String p_251450_, String p_249236_) {
        class_2446.method_36232(p_250791_, p_251817_, p_249619_, (class_7800)p_251154_, (class_1935)p_250066_, (float)p_251871_, (int)p_251316_, (String)p_251450_, (String)p_249236_);
    }

    public static void netheriteSmithing(Consumer<class_2444> p_251614_, class_1792 p_250046_, class_7800 p_248986_, class_1792 p_250389_) {
        class_2446.method_29728(p_251614_, (class_1792)p_250046_, (class_7800)p_248986_, (class_1792)p_250389_);
    }

    public static void trimSmithing(Consumer<class_2444> p_285086_, class_1792 p_285461_, class_2960 p_285044_) {
        class_2446.method_48530(p_285086_, (class_1792)p_285461_, (class_2960)p_285044_);
    }

    public static void twoByTwoPacker(Consumer<class_2444> p_248860_, class_7800 p_250881_, class_1935 p_252184_, class_1935 p_249710_) {
        class_2446.method_46209(p_248860_, (class_7800)p_250881_, (class_1935)p_252184_, (class_1935)p_249710_);
    }

    public static void threeByThreePacker(Consumer<class_2444> p_259036_, class_7800 p_259247_, class_1935 p_259376_, class_1935 p_259717_, String p_260308_) {
        class_2446.method_47521(p_259036_, (class_7800)p_259247_, (class_1935)p_259376_, (class_1935)p_259717_, (String)p_260308_);
    }

    public static void threeByThreePacker(Consumer<class_2444> p_260012_, class_7800 p_259186_, class_1935 p_259360_, class_1935 p_259263_) {
        class_2446.method_47522(p_260012_, (class_7800)p_259186_, (class_1935)p_259360_, (class_1935)p_259263_);
    }

    public static void planksFromLog(Consumer<class_2444> p_259712_, class_1935 p_259052_, class_6862<class_1792> p_259045_, int p_259471_) {
        class_2446.method_24475(p_259712_, (class_1935)p_259052_, p_259045_, (int)p_259471_);
    }

    public static void planksFromLogs(Consumer<class_2444> p_259910_, class_1935 p_259193_, class_6862<class_1792> p_259818_, int p_259807_) {
        class_2446.method_24477(p_259910_, (class_1935)p_259193_, p_259818_, (int)p_259807_);
    }

    public static void woodFromLogs(Consumer<class_2444> p_126003_, class_1935 p_126004_, class_1935 p_126005_) {
        class_2446.method_24476(p_126003_, (class_1935)p_126004_, (class_1935)p_126005_);
    }

    public static void woodenBoat(Consumer<class_2444> p_126022_, class_1935 p_126023_, class_1935 p_126024_) {
        class_2446.method_24478(p_126022_, (class_1935)p_126023_, (class_1935)p_126024_);
    }

    public static void chestBoat(Consumer<class_2444> p_236372_, class_1935 p_236373_, class_1935 p_236374_) {
        class_2446.method_42754(p_236372_, (class_1935)p_236373_, (class_1935)p_236374_);
    }

    public static class_5797 buttonBuilder(class_1935 p_176659_, class_1856 p_176660_) {
        return class_2446.method_33542((class_1935)p_176659_, (class_1856)p_176660_);
    }

    public static class_5797 doorBuilder(class_1935 p_176671_, class_1856 p_176672_) {
        return class_2446.method_33544((class_1935)p_176671_, (class_1856)p_176672_);
    }

    public static class_5797 fenceBuilder(class_1935 p_176679_, class_1856 p_176680_) {
        return class_2446.method_33546((class_1935)p_176679_, (class_1856)p_176680_);
    }

    public static class_5797 fenceGateBuilder(class_1935 p_176685_, class_1856 p_176686_) {
        return class_2446.method_33548((class_1935)p_176685_, (class_1856)p_176686_);
    }

    public static void pressurePlate(Consumer<class_2444> p_176691_, class_1935 p_176692_, class_1935 p_176693_) {
        class_2446.method_32813(p_176691_, (class_1935)p_176692_, (class_1935)p_176693_);
    }

    public static class_5797 pressurePlateBuilder(class_7800 p_251447_, class_1935 p_251989_, class_1856 p_249211_) {
        return class_2446.method_32806((class_7800)p_251447_, (class_1935)p_251989_, (class_1856)p_249211_);
    }

    public static void slab(Consumer<class_2444> p_248880_, class_7800 p_251848_, class_1935 p_249368_, class_1935 p_252133_) {
        class_2446.method_32814(p_248880_, (class_7800)p_251848_, (class_1935)p_249368_, (class_1935)p_252133_);
    }

    public static class_5797 slabBuilder(class_7800 p_251707_, class_1935 p_251284_, class_1856 p_248824_) {
        return class_2446.method_32804((class_7800)p_251707_, (class_1935)p_251284_, (class_1856)p_248824_);
    }

    public static class_5797 stairBuilder(class_1935 p_176711_, class_1856 p_176712_) {
        return class_2446.method_32808((class_1935)p_176711_, (class_1856)p_176712_);
    }

    public static class_5797 trapdoorBuilder(class_1935 p_176721_, class_1856 p_176722_) {
        return class_2446.method_33553((class_1935)p_176721_, (class_1856)p_176722_);
    }

    public static class_5797 signBuilder(class_1935 p_176727_, class_1856 p_176728_) {
        return class_2446.method_33555((class_1935)p_176727_, (class_1856)p_176728_);
    }

    public static void hangingSign(Consumer<class_2444> p_250663_, class_1935 p_252355_, class_1935 p_250437_) {
        class_2446.method_46208(p_250663_, (class_1935)p_252355_, (class_1935)p_250437_);
    }

    public static void colorBlockWithDye(Consumer<class_2444> p_289666_, List<class_1792> p_289675_, List<class_1792> p_289672_, String p_289641_) {
        class_2446.method_51890(p_289666_, p_289675_, p_289672_, (String)p_289641_);
    }

    public static void carpet(Consumer<class_2444> p_176717_, class_1935 p_176718_, class_1935 p_176719_) {
        class_2446.method_24885(p_176717_, (class_1935)p_176718_, (class_1935)p_176719_);
    }

    public static void bedFromPlanksAndWool(Consumer<class_2444> p_126074_, class_1935 p_126075_, class_1935 p_126076_) {
        class_2446.method_24887(p_126074_, (class_1935)p_126075_, (class_1935)p_126076_);
    }

    public static void banner(Consumer<class_2444> p_126082_, class_1935 p_126083_, class_1935 p_126084_) {
        class_2446.method_24889(p_126082_, (class_1935)p_126083_, (class_1935)p_126084_);
    }

    public static void stainedGlassFromGlassAndDye(Consumer<class_2444> p_126086_, class_1935 p_126087_, class_1935 p_126088_) {
        class_2446.method_24890(p_126086_, (class_1935)p_126087_, (class_1935)p_126088_);
    }

    public static void stainedGlassPaneFromStainedGlass(Consumer<class_2444> p_126090_, class_1935 p_126091_, class_1935 p_126092_) {
        class_2446.method_24891(p_126090_, (class_1935)p_126091_, (class_1935)p_126092_);
    }

    public static void stainedGlassPaneFromGlassPaneAndDye(Consumer<class_2444> p_126094_, class_1935 p_126095_, class_1935 p_126096_) {
        class_2446.method_24892(p_126094_, (class_1935)p_126095_, (class_1935)p_126096_);
    }

    public static void coloredTerracottaFromTerracottaAndDye(Consumer<class_2444> p_126098_, class_1935 p_126099_, class_1935 p_126100_) {
        class_2446.method_24893(p_126098_, (class_1935)p_126099_, (class_1935)p_126100_);
    }

    public static void concretePowder(Consumer<class_2444> p_126102_, class_1935 p_126103_, class_1935 p_126104_) {
        class_2446.method_24894(p_126102_, (class_1935)p_126103_, (class_1935)p_126104_);
    }

    public static void candle(Consumer<class_2444> p_176543_, class_1935 p_176544_, class_1935 p_176545_) {
        class_2446.method_32233(p_176543_, (class_1935)p_176544_, (class_1935)p_176545_);
    }

    public static void wall(Consumer<class_2444> p_251034_, class_7800 p_251148_, class_1935 p_250499_, class_1935 p_249970_) {
        class_2446.method_32809(p_251034_, (class_7800)p_251148_, (class_1935)p_250499_, (class_1935)p_249970_);
    }

    public static class_5797 wallBuilder(class_7800 p_249083_, class_1935 p_250754_, class_1856 p_250311_) {
        return class_2446.method_33531((class_7800)p_249083_, (class_1935)p_250754_, (class_1856)p_250311_);
    }

    public static void polished(Consumer<class_2444> p_251348_, class_7800 p_248719_, class_1935 p_250032_, class_1935 p_250021_) {
        class_2446.method_32810(p_251348_, (class_7800)p_248719_, (class_1935)p_250032_, (class_1935)p_250021_);
    }

    public static class_5797 polishedBuilder(class_7800 p_249131_, class_1935 p_251242_, class_1856 p_251412_) {
        return class_2446.method_33537((class_7800)p_249131_, (class_1935)p_251242_, (class_1856)p_251412_);
    }

    public static void cut(Consumer<class_2444> p_248712_, class_7800 p_252306_, class_1935 p_249686_, class_1935 p_251100_) {
        class_2446.method_32811(p_248712_, (class_7800)p_252306_, (class_1935)p_249686_, (class_1935)p_251100_);
    }

    public static class_2447 cutBuilder(class_7800 p_250895_, class_1935 p_251147_, class_1856 p_251563_) {
        return class_2446.method_36547((class_7800)p_250895_, (class_1935)p_251147_, (class_1856)p_251563_);
    }

    public static void chiseled(Consumer<class_2444> p_250120_, class_7800 p_251604_, class_1935 p_251049_, class_1935 p_252267_) {
        class_2446.method_32812(p_250120_, (class_7800)p_251604_, (class_1935)p_251049_, (class_1935)p_252267_);
    }

    public static void mosaicBuilder(Consumer<class_2444> p_249200_, class_7800 p_248788_, class_1935 p_251925_, class_1935 p_252242_) {
        class_2446.method_46212(p_249200_, (class_7800)p_248788_, (class_1935)p_251925_, (class_1935)p_252242_);
    }

    public static class_2447 chiseledBuilder(class_7800 p_251755_, class_1935 p_249782_, class_1856 p_250087_) {
        return class_2446.method_32805((class_7800)p_251755_, (class_1935)p_249782_, (class_1856)p_250087_);
    }

    public static void stonecutterResultFromBase(Consumer<class_2444> p_251589_, class_7800 p_248911_, class_1935 p_251265_, class_1935 p_250033_) {
        class_2446.method_33717(p_251589_, (class_7800)p_248911_, (class_1935)p_251265_, (class_1935)p_250033_);
    }

    public static void stonecutterResultFromBase(Consumer<class_2444> p_249145_, class_7800 p_250609_, class_1935 p_251254_, class_1935 p_249666_, int p_251462_) {
        class_2446.method_33715(p_249145_, (class_7800)p_250609_, (class_1935)p_251254_, (class_1935)p_249666_, (int)p_251462_);
    }

    public static void smeltingResultFromBase(Consumer<class_2444> p_176740_, class_1935 p_176741_, class_1935 p_176742_) {
        class_2446.method_34662(p_176740_, (class_1935)p_176741_, (class_1935)p_176742_);
    }

    public static void nineBlockStorageRecipes(Consumer<class_2444> p_249580_, class_7800 p_251203_, class_1935 p_251689_, class_7800 p_251376_, class_1935 p_248771_) {
        class_2446.method_36325(p_249580_, (class_7800)p_251203_, (class_1935)p_251689_, (class_7800)p_251376_, (class_1935)p_248771_);
    }

    public static void nineBlockStorageRecipesWithCustomPacking(Consumer<class_2444> p_250488_, class_7800 p_250885_, class_1935 p_251651_, class_7800 p_250874_, class_1935 p_248576_, String p_250171_, String p_249386_) {
        class_2446.method_36446(p_250488_, (class_7800)p_250885_, (class_1935)p_251651_, (class_7800)p_250874_, (class_1935)p_248576_, (String)p_250171_, (String)p_249386_);
    }

    public static void nineBlockStorageRecipesRecipesWithCustomUnpacking(Consumer<class_2444> p_250320_, class_7800 p_248979_, class_1935 p_249101_, class_7800 p_252036_, class_1935 p_250886_, String p_248768_, String p_250847_) {
        class_2446.method_36449(p_250320_, (class_7800)p_248979_, (class_1935)p_249101_, (class_7800)p_252036_, (class_1935)p_250886_, (String)p_248768_, (String)p_250847_);
    }

    public static void copySmithingTemplate(Consumer<class_2444> p_267061_, class_1935 p_266974_, class_6862<class_1792> p_267283_) {
        class_2446.method_48532(p_267061_, (class_1935)p_266974_, p_267283_);
    }

    public static void copySmithingTemplate(Consumer<class_2444> p_266734_, class_1935 p_267133_, class_1935 p_267023_) {
        class_2446.method_48533(p_266734_, (class_1935)p_267133_, (class_1935)p_267023_);
    }

    public static void cookRecipes(Consumer<class_2444> p_126007_, String p_126008_, class_1865<? extends class_1874> p_250529_, int p_126010_) {
        class_2446.method_17585(p_126007_, (String)p_126008_, p_250529_, (int)p_126010_);
    }

    public static void simpleCookingRecipe(Consumer<class_2444> p_249398_, String p_249709_, class_1865<? extends class_1874> p_251876_, int p_249258_, class_1935 p_250669_, class_1935 p_250224_, float p_252138_) {
        class_2446.method_36448(p_249398_, (String)p_249709_, p_251876_, (int)p_249258_, (class_1935)p_250669_, (class_1935)p_250224_, (float)p_252138_);
    }

    public static void waxRecipes(Consumer<class_2444> p_176611_) {
        class_2446.method_34854(p_176611_);
    }

    public static void generateRecipes(Consumer<class_2444> p_176581_, class_5794 p_176582_) {
        class_2446.method_33535(p_176581_, (class_5794)p_176582_);
    }

    public static class_2248 getBaseBlock(class_5794 p_176524_, class_5794.class_5796 p_176525_) {
        return class_2446.method_33533((class_5794)p_176524_, (class_5794.class_5796)p_176525_);
    }

    public static class_2037.class_2039 insideOf(class_2248 p_125980_) {
        return class_2446.method_10422((class_2248)p_125980_);
    }

    public static class_2066.class_2068 has(class_2096.class_2100 p_176521_, class_1935 p_176522_) {
        return class_2446.method_35914((class_2096.class_2100)p_176521_, (class_1935)p_176522_);
    }

    public static class_2066.class_2068 has(class_1935 p_125978_) {
        return class_2446.method_10426((class_1935)p_125978_);
    }

    public static class_2066.class_2068 has(class_6862<class_1792> p_206407_) {
        return class_2446.method_10420(p_206407_);
    }

    public static class_2066.class_2068 inventoryTrigger(class_2073 ... p_126012_) {
        return class_2446.method_10423((class_2073[])p_126012_);
    }

    public static String getHasName(class_1935 p_176603_) {
        return class_2446.method_32807((class_1935)p_176603_);
    }

    public static String getItemName(class_1935 p_176633_) {
        return class_2446.method_33716((class_1935)p_176633_);
    }

    public static String getSimpleRecipeName(class_1935 p_176645_) {
        return class_2446.method_36450((class_1935)p_176645_);
    }

    public static String getConversionRecipeName(class_1935 p_176518_, class_1935 p_176519_) {
        return class_2446.method_33714((class_1935)p_176518_, (class_1935)p_176519_);
    }

    public static String getSmeltingRecipeName(class_1935 p_176657_) {
        return class_2446.method_36451((class_1935)p_176657_);
    }

    public static String getBlastingRecipeName(class_1935 p_176669_) {
        return class_2446.method_36452((class_1935)p_176669_);
    }
}

